﻿using RimWorld;
using UnityEngine;
using Verse;

namespace MaliExtinguishRefuelables
{
	public class CompProperties_FireOverlayExtinguishable : CompProperties
	{
		public float fireSize = 1f;

		public float finalFireSize = 1f;

		public float fireGrowthDurationTicks = -1f;

		public Vector3 offset;

		public CompProperties_FireOverlayExtinguishable()
		{
			compClass = typeof(CompFireOverlayExtinguishable);
		}

		public override void DrawGhost(IntVec3 center, Rot4 rot, ThingDef thingDef, Color ghostCol, AltitudeLayer drawAltitude, Thing thing = null)
		{
			GhostUtility.GhostGraphicFor(CompFireOverlay.FireGraphic, thingDef, ghostCol).DrawFromDef(center.ToVector3ShiftedWithAltitude(drawAltitude), rot, thingDef);
		}
	}

}
